# JIS LCD Font test -- 2018/10/24 tklua@wifiboy.org

''' 
JIS: http://charset.7jp.net/jis.html
JIS converter: https://r12a.github.io/app-encodings/
'''

def jisoffset(x):
    x1=x>>8
    x2=x%256
    n=(x1-33)*94*18+(x2-33)*18+120
    return n
    
def showjis(b, x, y, c):
    count = 0
    cx=x
    for i in range(18):
        for j in range(4):
            if b[i]&(2**(7-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
        for j in range(4):
            if b[i]&(2**(3-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
            
jisstr = [0x3835,0x3524,0x244A,0x3B51,0x382B,0x243F,0x2424]            
posx, posy = 10, 30
color = wb.WHITE

wb.cls()
with open("/sd/font/FJIS12F.PDB", "rb") as f:
    for ch in jisstr:
        f.seek(jisoffset(ch))
        showjis(f.read(18), posx, posy, color)
        posx += 14
    f.close()
    